<?php
//
//  Copyright (c) 2014 NetApp, Inc.
//  All rights reserved.
//

// VERSION="1.0"

//
// Check if volumes are offline
//
include 'mcc_util.php';
global $mccconfigured;
global $mccswitchedover;
$offlinevolfound = false;


$options = getoptreq('',array("major:", "downgrade::"));
$majorupgrade = $options["major"];

if(!isValidMCCState()) {
    exit;
}

if ($majorupgrade == "false") {
    exit;
}

$query = "SELECT vserver,aggregate FROM volume WHERE state != online AND state != restricted AND type != DEL";
$result = dotsql_query($query);

if ($mccconfigured) {
    while ($row = dotsql_fetch_object($result)) {
        //echo "Some offline volumes exist...";
        $vserver = $row->vserver;
        $query = "SELECT type,subtype FROM vserver WHERE vserver = $vserver";
        $resultvs = dotsql_query($query);
        //echo "Vserver query for $vserver is done...";
        if ($rowvs = dotsql_fetch_object($resultvs)) {
            //echo "Got vserver properties from vserver table...";
            if($rowvs->type == 'admin') {
                //echo "vserver is a CSERVER. Finding if volume is from remote cluster...";
                $aggregate = $row->aggregate;
                $query = "SELECT cluster-id FROM aggr WHERE aggregate = $aggregate";
                $resultag = dotsql_query($query);
                if($rowag = dotsql_fetch_object($resultag)) {
                    //echo "Got the aggregate properties from aggr table...";
                    $clusterid = $rowag->{'cluster-id'};
                    $query = "SELECT uuid from cluster_id";
                    $resultcid = dotsql_query($query);
                    if($rowcid = dotsql_fetch_object($resultcid)) {
                        if($rowcid->uuid != $clusterid) {
                            //echo "cluster-id of aggr is not local, contuining...";
                            continue;
                        }
                    }
                }
                $offlinevolfound = true;
                break;
            }
            if($rowvs->subtype != 'sync-destination') {
                //echo "Vserver type is NOT sync-destination, offline vol found...";
                $offlinevolfound = true;
                break;
            } elseif ($mccswitchedover) {
                //echo "Vserver type is sync-destination, but in switchedover state. Offline vol found...";
                $offlinevolfound = true;
                break;
            }
        }
    }
} elseif (dotsql_num_rows($result)) {
    //echo "Not an MCC configuration and there are some offline volumes...";
    $offlinevolfound = true;
}



if ($offlinevolfound) {
    echo "<Alert>Volumes were found that must be changed to online state before attempting NDU.</Alert> <Action>To check for volumes that need to be brought online, run the command: volume show -state !online -state !restricted</Action> ";
    echo "<Advice>Check for offline volumes in the cluster.</Advice>";
    echo "<RC>error</RC>";
}
exit;
?>
