<?php
//  Copyright (c) 2016 NetApp, Inc.
//  All rights reserved.

// NDU Compatibility for number of snapshots

function logDebugMessage($message)
{
    $dbgquery = "CALL add_scripting_log_message('validation_rules_snapshot: $message','false')";
    $result = dotsql_query($dbgquery);
}

function warnUser($nodesArray, $MAX_SNAPS)
{
    echo "<Alert>";
    echo "The total number Snapshot copies stored per node exceeds the ";
    echo "supported limit of $MAX_SNAPS on the following nodes: ";
    echo join(', ', $nodesArray).".";
    echo "</Alert><Action>";
    echo "Please delete unneeded Snapshot copies within volumes of these ";
    echo "nodes to bring the node Snapshot copy count below the upgrade ";
    echo "limit before attempting NDU. ";
    echo "Use command \"volume snapshot show\" to list Snapshot copies ";
    echo "and \"volume snapshot delete\" to delete Snapshot copies.";
    echo "</Action><Advice>";
    echo "Please delete unneeded Snapshot copies within volumes of these ";
    echo "nodes to bring the node Snapshot copy count below the upgrade ";
    echo "limit before attempting NDU.";
    echo "</Advice>";
    echo "<RC>error</RC>";
}

$MAX_SNAPS = 20000;

$node_snapshots_message_array = array();
$node_snapshots_array = array();

$node_snapshots_query = "SELECT node, snapshot-count FROM volume";
$node_snapshots_result = dotsql_query($node_snapshots_query);

while ($node_snapshots_row = dotsql_fetch_object($node_snapshots_result)) {
    $node_snapshots_array[$node_snapshots_row->{'node'}] += $node_snapshots_row->{'snapshot-count'};
}

foreach ($node_snapshots_array as $node_name => $node_snapshots_count) {
    if ($node_snapshots_count > $MAX_SNAPS) {
        array_push($node_snapshots_message_array, "$node_name (Snapshot copies: $node_snapshots_count)");
    }
}

if (count($node_snapshots_message_array) > 0) {
    warnUser($node_snapshots_message_array, $MAX_SNAPS);
}

exit;
?>
