<?php
//
// Copyright (c) 2016 NetApp, Inc.
// All rights reserved.
//
// VERSION="1.0"

// Check for ONTAP version.
// 1. All nodes should be running same version of Data ONTAP.
include 'mcc_util.php';
$options = getoptreq('',array("major:", "downgrade::"));
$major = $options["major"];
if ($major != "true") {
	exit;
}

$query = "SELECT generation, major, minor from  cluster_version_replicated";
$result = dotsql_query($query);
$versionlist = array();
while($row = dotsql_fetch_object($result)) {
	$version = sprintf("%d.%d.%d", $row->generation, $row->major, $row->minor);
	array_push($versionlist, $version);
}
// Retain the unique values in the array.
$versionlist = array_flip($versionlist);
if(count($versionlist) > 2) {
	echo "<Alert>Nodes are not running the same version of Data ONTAP.</Alert>";
	echo "<Action>Ensure the nodes being updated are running same version of Data ONTAP.</Action>";
        echo "<Advice>Ensure the nodes being updated are running same version of Data ONTAP.</Advice>";
        echo "<RC>error</RC>";
}

// 2. Upgrade should not result in more than 2 version of Data ONTAP in the cluster.
$siquery = "SELECT version from software_image where isdefault = true";
$siresult = dotsql_query($siquery);
$tgtversionlist = array();
while($sirow = dotsql_fetch_object($siresult)) {
	$siversion = $sirow->version;
	// If the $siversion is say Harpoon__9.1.0. the command below adds 9.1.0 to the array.
	array_push($tgtversionlist, substr($siversion, strpos($siversion, '_')+2, 5));
}
$handle = popen("pwd 2>&1", "r");
$tgtversion = fread($handle, 2096);
pclose($handle);
// If the $tgtversion is say /mroot/etc/NDU/store/Longboard__9.1.0. the command below adds 9.1.0 to the array.
array_push($tgtversionlist, substr($tgtversion, strpos($tgtversion, '_')+2, 5));
$tgtversionlist = array_flip($tgtversionlist);
if(count($tgtversionlist) > 2) {
	echo "<Alert>Upgrading the nodes will lead to more than two versions of Data ONTAP in the cluster during or after upgrade, which is not supported.</Alert>";
        echo "<Action>Ensure all the nodes are running the same version of Data ONTAP.</Action>";
        echo "<Advice>Ensure all the nodes are running the same version of Data ONTAP.</Advice>";
        echo "<RC>error</RC>";
}
end;
?>
