<?php
//
//  Copyright (c) 2014 NetApp, Inc.
//  All rights reserved.
//
// VERSION="1.0"
// NDU Compatibility for SCON

include 'vserver_state_cache.php';

// this is the max number of incorrectly configured lifs we will report.
// If there are additional misconfigured LIFs, then we will not list details
// of them, just note there are additional ones not listed
$MAX_LIFS_TO_REPORT = 3;

// search for LIFs that have a failover-policy of disabled and warn the 
// admin
$query = "SELECT vserver, failover-policy, lif, data-protocol, role FROM virtual_interface where status-admin=up and failover-policy=disabled";
$result = dotsql_query($query);
$first = 1;
$lifCount=0;
unset( $row );
unset( $lifs );

while ($row = dotsql_fetch_object($result)) {

    unset( $vserverName );
    unset( $vserverState );
    unset( $vserverType );

    $vserverName =$row->{'vserver'}; 

    // fcp lifs do not fail over so don't check them
    if( strcmp($row->{'data-protocol'}, "fcp") == 0 ){
	continue;
    }

    // iscsi lifs do not fail over so don't check them
    if( strcmp($row->{'data-protocol'}, "iscsi") == 0 ){
	continue;
    }

    // node-mgmt lifs are pinned to the node and will go off-line
    // when node is rebooted, so skip them
    if( strcmp($row->{'role'},"node-mgmt") == 0 ){
	continue;
    }

    // intercluster lifs are pinned to the node and will go off-line
    // when node is rebooted, so skip them
    if( strcmp($row->{'role'},"intercluster") == 0 ){
	continue;
    }

    list($vserverState,$vserverType) = getVserverInfo($vserverName);
    
    // don't check lifs that are not in data or the admin vserver
    if( (0 != strcmp( $vserverType, "admin" ))
	    && (0 != strcmp( $vserverType, "data" ))){
	continue;
    }

    // we only want to check running vservers.  System vservers do not
    // have an associated state and are always running so we treat the
    // empty value as running
    if( !$vserverState || $vserverState == "running" ){

	$lif = $row->{'lif'};
	$lifCount++;

	if( $lifCount <= $MAX_LIFS_TO_REPORT ){
	    // build a list of the remaining LIFs with disabled failover policies 
	    if( $first == 0 ){
		$lifs .= ",";
	    }
	    else{
		$first = 0;
	    }
	    $lifs .= "\"$lif\" on Vserver \"$vserverName\"";
	}
    }
}

if( $lifs ){
    unset( $msg );
    if( $lifCount == 1 ){
	$msg = "LIF %s has ";
    }
    else{
	$additionalLifMsg = "";
	if( $lifCount > $MAX_LIFS_TO_REPORT ){
	    $unlabeledLifCount = $lifCount - $MAX_LIFS_TO_REPORT;
	    $additionalLifMsg .= "and $unlabeledLifCount other LIFs";
	}
	
	$msg = "LIFs %s $additionalLifMsg have ";
    }
    
    $msg .= "a failover policy set to \"disabled\" and will no longer be hosted when its current node is rebooted or a takeover occurs.";
    $msg = sprintf( $msg, $lifs );

    echo "<Alert>$msg</Alert>";
    echo "<Action>To identify LIFs with a failover-policy set to \"disabled\" use the \"network interface show -failover-policy disabled\" command. ";
    echo "To enable LIF failover use the \"network interface modify -vserver <Vserver> -lif <lif name> -failover-policy <failover-policy>\" command.</Action>";
    echo "<Advice>Modify the failover-policies of the LIFs to a value other than \"disabled\".</Advice>";
    echo "<RC>warning</RC>";
}

exit;
?>

