<?php
//
//  Copyright (c) 2015 NetApp, Inc.
//  All rights reserved.
//
// VERSION="1.0"
// NDU Compatibility for CIFS

$query = "SELECT continuously-available FROM cifs_session";

$result = dotsql_query($query);

while ($row = dotsql_fetch_object($result)) {
     $state = $row->{'continuously-available'};
     if ($state == 'Partial' || $state == 'No') {
	   echo "<Alert>CIFS is currently in use.  Any unprotected sessions may be affected with possible loss of data.</Alert>";
	   echo "<Action>Stop all unprotected CIFS workloads before performing the update.";
	   echo "To list the unprotected CIFS workloads, run the command: vserver cifs session show -continuously-available No, Partial </Action>";
	   echo "<Advice>Stop all unprotected CIFS workloads before performing the update.</Advice>";
	   echo "<RC>warning</RC>";
	   exit;
   }
}

// Check if there are any continuously-available share (Hyper-V or SQL over SMB). If any,
//    Total number of volumes per node should be <= 200
//    Total number of LUNs per node should be <= 400
//

//-------------------------------------------------------------------------------------------------

$caShareFound   = false;

//-------------------------------------------------------------------------------------------------

function logDebugMessage($message)
{
    $dbgquery = "CALL add_scripting_log_message('validation_rules_CIFS: $message','false')";
    $result = dotsql_query($dbgquery);
}


function warnUser($nodesArray, $MAX_VOLUMES, $MAX_LUNS)
{
    echo "<Alert>";
    echo "The total number of volumes and/or luns configured per node exceeds the supported
         limit of ".($MAX_VOLUMES)." volumes and/or ".($MAX_LUNS)." LUNs per node for NDU in the following nodes: \n";
    echo join(', ', $nodesArray);
    echo "</Alert> <Action>";
    echo "Ensure that they are within the supported limits before attempting NDU.";
    echo "</Action>";
    echo "<Advice>Contact Netapp's technical support for help.</Advice>";
    echo "<RC>warning</RC>";
}

//-------------------------------------------------------------------------------------------------

$query = "SELECT share-name FROM cifs_share WHERE share-properties = 'continuously-available'";
$result = dotsql_query($query);

$numCaShares = dotsql_num_rows($result);

if($numCaShares > 0)
{
    $caShareFound = true;
    $message = "CIFS CA share(s) found. Total CA share(s) = ".($numCaShares);
    logDebugMessage($message);
}
else
{
    logDebugMessage("No CIFS CA shares found.");
}


//-------------------------------------------------------------------------------------------------

if($caShareFound)
{
    $nodeCount   = 0;
    $MAX_VOLUMES = 200;
    $MAX_LUNS    = 400;
    $nodesArray  = array();

    $query = "SELECT node FROM node";
    $node_result = dotsql_query($query);

    while ($row = dotsql_fetch_object($node_result))
    {
        $node = $row->node;

        $query = "SELECT node,volume FROM volume WHERE node = $node";
        $result = dotsql_query($query);

        $numVolumes = dotsql_num_rows($result);
        $message = "Total volumes found in ".($node)." = ".($numVolumes);
        logDebugMessage($message);

        $query = "SELECT lun FROM lun WHERE node = $node";
        $result = dotsql_query($query);

        $numLuns = dotsql_num_rows($result);
        $message = "Total LUNs found in ".($node)." = ".($numLuns);
        logDebugMessage($message);

        if(($numVolumes > $MAX_VOLUMES) || ($numLuns > $MAX_LUNS))
        {
            $nodesArray[$nodeCount] = $node;
            $nodeCount = $nodeCount + 1 ;
        }
    }

    if($nodeCount > 0)
    {
       logDebugMessage("CIFS NDU validation FAILED.");
       warnUser($nodesArray, $MAX_VOLUMES, $MAX_LUNS);
    }
    else
    {
       logDebugMessage("CIFS NDU validation PASSED.");
    }
}

//-------------------------------------------------------------------------------------------------

exit;
?>
