<?php
//
//  Copyright (c) 2014 NetApp, Inc.
//  All rights reserved.
//

// VERSION="1.0"

//
// Check if any aggregate is resyncing
//
include 'mcc_util.php';

function logDebugMessage($message) {
    $dbgquery = "CALL add_scripting_log_message('validation_rules_aggr_mirror: $message','false')";
    $result = dotsql_query($dbgquery);
}

global $mccconfigured;
$resyncplexfound = false;

if (!isValidMCCState()) {
    exit;
}

if (!mccconfigured) {
    exit;
}

$localdrcstate = getMCCOperationState();

if (($localdrcstate != 'healing-aggrs-completed') &&
    ($localdrcstate != 'healing-roots-completed')) {
    exit;
}

$queryaggr = "SELECT aggregate FROM aggr_plex WHERE in-progress = true";
$resultaggr = dotsql_query($queryaggr);

if (dotsql_num_rows($resultaggr)) {
    $resyncplexfound = true;
}

if ($resyncplexfound) {
    $options = getoptreq('',array("major:", "downgrade::"));
    $majorupgrade = $options["major"];

    echo "<Alert>Some aggregates are still resynchronizing after the last switchover operation. Make sure all plexes are up-to-date before attempting NDU.</Alert>";
    echo "<Action>Use the \"storage aggregate plex show -in-progress true\" command to check for resynchronizing plexes.</Action>";
    echo "<Advice>Check for resynchronizing aggregate plexes in the cluster.</Advice>";
    if($majorupgrade == "true") {
        echo "<RC>error</RC>";
    }
    else {
        echo "<RC>warning</RC>";
    }
} else {
    logDebugMessage("No resyncing plexes were found");
}

exit;
?>
