<?php
//
// Copyright (c) 2016 NetApp, Inc.
// All rights reserved.
//

// Check for previous upgrade status
include 'mcc_util.php';
$options = getoptreq('',array("major:", "downgrade::"));
$major = $options["major"];
if ($major != "true") {
	exit;
}
$urincomplete = false;
$imgquery = "select version from software_image where node = local and iscurrent = true";
$imgresult = dotsql_query($imgquery);
if($imgrow = dotsql_fetch_object($imgresult)) {
	$imgversion = $imgrow->version;
}

$lineno  = 0;
$myfile = fopen("/var/INTERNCONFVERS", "r");
if( $myfile != false) {
    while($line=fgets($myfile,65535)) {
        $lineno  =  $lineno +1;
	if ($lineno == 4) {
	    //Extract only the version number, the string includes some white spaces that need to ignored.
	    $version = substr($line,0,3);
	    break;
	}
    }
    fclose($myfile);

    if (strpos($imgversion, "__")) {
        // Change imgversion that is like "Fullsteam__8.3.2X14" to "8.3.2X14"
	$imgversion = substr($imgversion, strpos($imgversion, '__')+2);
    }

    // An imgversion could be either "8.3.2", "8.3.2X14" etc.
    // Extract only the generation, major and minor versions from
    // imgversion for fetching the entries from versionlist array.
    sscanf($imgversion, "%d.%d.%d", $generation, $major, $minor);
    $index = sprintf("%d.%d.%d", $generation, $major, $minor);

    // This script runs for upgrades from ONTAP version 8.3.x
    $versionlist = array("8.3.0"=>"400", "8.3.1"=>"410", "8.3.2"=>"420");

    // If $versionlist array doesn't have a mapping for $index we obtained
    // we ignore the script to continue with next checks rather than failing
    // so as to prevent wrong failure indication (see burt 1015462).
    //     If the value $index is present in the $versionlist array and
    // $imgversion from INTERCONFVERS doesn't match, then it is considered
    // an incomplete update.
    if (!empty($versionlist[$index]) && strcasecmp($version, $versionlist[$index]) != 0) {
	$urincomplete = true;
    }
}

$node_status = 0;
$query = "SELECT node-status FROM cluster_upgrade_version_status";
$result = dotsql_query($query);
while ($row = dotsql_fetch_object($result)) {
	$node_status = $row->{'node-status'};
	if ((strcmp($node_status, "complete")!= 0) && (strcmp($node_status, "not-needed") != 0)) {
		$urincomplete = true;
	}
}
if ($urincomplete == true) {
	echo "<Alert>Upgrade is not complete on few nodes.</Alert>";
	echo "<Action>To complete the upgrade, run the advanced privilege command \"system node upgrade-revert upgrade\" on each node.</Action>";
	echo "<Advice>Resolve the upgrade issues and retry the operation.</Advice>";
	echo "<RC>error</RC>";
}
end;
?>
