<?php
//
//  Copyright (c) 2015 NetApp, Inc.
//  All rights reserved.
//
// VERSION="1.0"
// This script checks if SSLv3 was enabled on the cluster
// and warns the user that SSLv3 connection won't work
// post upgrade to LB.0 since SSLv3 is DISABLED by default
// and need to explicitly enabled using security config
// modify command.

// Check the Web Services Configuration
$query = "SELECT sslv3-enabled FROM cluster_web_config WHERE 'sslv3-enabled'=\"true\"";

$result = dotsql_query($query);

if(dotsql_num_rows($result) > 0) {
   $alert = "protocol SSLv3 is currently enabled in web configuration. ";
   $alert .= "This protocol is considered insecure and will be disabled when you upgrade to Data ONTAP 9.0.0. ";
   $action = "If the client interfaces to Data ONTAP have any of the TLS protocols enabled, for example, TLSv1, TLSv1.1, TLvS1.2, ";
   $action .= "no further action is required. ";
   $action .= "Otherwise, atleast one of the TLS protocol should be available at the client interfaces to ensure connectivity. ";
   $action .= "To view the web services configuration, run the command: ";
   $action .= "system services web show";
   $advice = "If the client interfaces to ONTAP have any of the TLS protocols enabled, for example, TLSv1, TLSv1.1, TLvS1.2, ";
   $advice .= "no further action is required. ";
   $advice .= "Otherwise, at least one of the TLS protocol should be available at the client interfaces to ensure connectivity.";
   logAndWarnUser($alert, $action, $advice);
   exit;
}

$arr_config = array();

// Check the LDAP client config
$query = "SELECT client-config FROM ldap_config WHERE 'client-enabled'=\"true\"";

$result = dotsql_query($query);

if(dotsql_num_rows($result) > 0) {
	while ($row = dotsql_fetch_object($result)) {
		$config = $row->{'client-config'};
		if(!in_array($config, $arr_config)) {
			array_push($arr_config, $config);
		}
	}
}

foreach ($arr_config as $ldap_config) {
	$query = "SELECT allow-ssl FROM ldap_client_config WHERE 'client-config'=\"". $ldap_config . "\"";

	$result = dotsql_query($query);

	if(dotsql_num_rows($result) > 0) {
		while ($row = dotsql_fetch_object($result)) {
		     if($row->{'allow-ssl'} == 'true') {
			   $alert = "protocol SSLv3 is currently enabled in LDAP client configuration. ";
			   $alert .= "This protocol is considered insecure and will be disabled when you upgrade to Data ONTAP 9.0.0. ";
			   $action = "If LDAP server has any of the TLS protocols enabled, for example, TLSv1, TLSv1.1, TLvS1.2, ";
			   $action .= "no further action is required. ";
			   $action .= "Otherwise, atleast one of the TLS protocols should be enabled at the server to ensure connectivity. ";
			   $action .= "To view the LDAP client configuration, run the command: ";
			   $action .= "vserver services name-service ldap client show -client-config ". $ldap_config;
			   $advice = "If LDAP server has any of the TLS protocols enabled, for example, TLSv1, TLSv1.1, TLvS1.2, ";
			   $advice .= "no further action is required. ";
			   $advice .= "Otherwise, at least one of the TLS protocols should be enabled at the server to ensure connectivity.";
			   logAndWarnUser($alert, $action, $advice);
			   exit;
		   }
		}
	}
}

//-------------------------------------------------------------------------------------------------

function logDebugMessage($message)
{
    $dbgquery = "CALL add_scripting_log_message('validation_rules_security_config: $message','false')";
    $result = dotsql_query($dbgquery);
}


function logAndWarnUser($alert, $action, $advice)
{
    logDebugMessage($alert);
    echo "<Alert>";
    echo $alert;
    echo "</Alert>";
    echo "<Action>";
    echo $action;
    echo "</Action>";
    echo "<Advice>";
    echo $advice;
    echo "</Advice>";
    echo "<RC>warning</RC>";
}

//-------------------------------------------------------------------------------------------------

exit;
?>
