<?php
//
//  Copyright (c) 2014 NetApp, Inc.
//  All rights reserved.
//

// VERSION="1.0"
// common code implementation for vserver state cache

class vserverInfo{
    var $type;
    var $state;
};

// this function will look in a cache to get the vserver admin-state and type.  
// The key to the cache is the name of the vserver.  If the vserver information
// is not in the cache it is populated from rdb.
function getVserverInfo( $vserverName)
{
    // in php, static means the contents survive exiting the scope of the function.  But the scope where
    // the variable can be referenced is local to the function
    static $vserverCache;

    // check cache for vserver admin state and type 
    if($vserverCache[$vserverName]){
	$vserverState=$vserverCache[$vserverName]->state;
	$vserverType=$vserverCache[$vserverName]->type;
	return array($vserverState, $vserverType);
    }
    else{
	// not there so populate it
	$vsrvNameQuery = "SELECT admin-state, type FROM vserver WHERE vserver=" . $vserverName;
	$vsrvResult = dotsql_query($vsrvNameQuery);
	if( $vsrvResult && (dotsql_num_rows( $vsrvResult ) == 1) ) {
	    $vsrvRow = dotsql_fetch_object($vsrvResult);
	    if( $vsrvRow ){
		// get the vserver name,state and add it to the cache
		$vserverState=$vsrvRow->{'admin-state'};
		$vserverType=$vsrvRow->{'type'};

		$cacheEntry = new vserverInfo;
		$cacheEntry->type=$vserverType;
		$cacheEntry->state=$vserverState;

		$vserverCache[$vserverName]=$cacheEntry;
		return array($vserverState, $vserverType);
	    }
	}
    }
}
?>
