<?php
//
//  Copyright (c) 2016 NetApp, Inc.
//  All rights reserved.
//

// VERSION="1.0"

//
// Each node with a mapped LUN must have a SAN LIF on the node and HA partner in the same Vserver
//

// Initialise variables and arrays
$printed = false;
$HApartners = array();
$set = array();
$lifset = array();

// Get partner node from storage_failover table
$query = "SELECT node-name,partner-name FROM storage_failover";
$result = dotsql_query($query);
while ($row = dotsql_fetch_object($result)) {
    $HApartners[$row->{'node-name'}] = $row->{'partner-name'};
}

// Get node,vserver names from lun map table
$query = "SELECT node,vserver FROM map";
$result = dotsql_query($query);
while ($row = dotsql_fetch_object($result)) {
    $topush = ($row->node).": ".($row->vserver);
    array_push($set, $topush);

    if(empty($HApartners[$row->node])){
        // Do nothing if HA partner name couldn't be found for some reason
    }
    else {
        $topush = ($HApartners[$row->node]).": ".($row->vserver);
        array_push($set, $topush);
    }
}

$set = array_unique($set);
$count = count($set);

// Get list of all SAN LIFs from virtual_interface table
$lifquery = "SELECT home-node,vserver FROM virtual_interface WHERE data-protocol=iscsi|fcp";
$lifqueryresult = dotsql_query($lifquery);
$lifset = array();
while ($row = dotsql_fetch_object($lifqueryresult)) {
    $topush = ($row->{'home-node'}).": ".($row->vserver);
    array_push($lifset, $topush);
}
$lifset = array_unique($lifset);

// Advise to create SAN LIFs on (node: vserver) pairs
for ($i=0; $i < $count; $i++) {
    $popped_element = array_pop($set);
    if(in_array($popped_element,$lifset)==false){
        if ($printed != true) {
            echo "<Alert>Configure SAN LIFs on the following node-vserver pairs: $popped_element";
            $printed = true;
        } else {
            echo ", $popped_element";
        }
    }
}

if ($printed == true) {
    echo "</Alert>";
    echo "<Action>Run 'network interface create' with '-data-protocol' option equal to 'fcp' or 'iscsi' to create SAN LIF(s) on the node-vserver pairs shown</Action>";
    echo "<Advice>Ensure that any node with a mapped LUN and its HA partner have at least one SAN LIF each in the same vserver as the LUN</Advice>";
    echo "<RC>warning</RC>";
}

exit;
?>

