<?php
//
//  Copyright (c) 2014-2015 NetApp, Inc.
//  All rights reserved.
//

// NDU Compatibility for metrocluster
    include 'mcc_util.php';

    $mccstate = getMCCConfigState();
    if ($mccstate == 'partially-configured' || $mccstate == 'configured') {

        $options = getoptreq('',array("major:", "downgrade::"));
        $majorupgrade = $options["major"];

        if ($majorupgrade == "true") {
            echo "<Alert>Automated NDU does not support major version upgrades of a MetroCluster configuration.</Alert>";
            echo "<Action>Use manual upgrade procedures to upgrade the clusters.</Action>";
            echo "<Advice>Use manual upgrade procedures to upgrade the clusters.</Advice>";
            echo "<RC>error</RC>";
            exit;
        }

        //$drcstate = getMCCOperationState();
        $localmode = getLocalMode();
        //if ($drcstate == 'switchover-completed' || $drcstate == 'healing-aggrs-completed' || $drcstate == 'healing-roots-completed') {
        if ($localmode == 'switchover') {
	    echo "<Alert>MetroCluster is in switchover state.</Alert>";
	    echo "<Action>The update can be done on this cluster. Ensure the DR site is also updated to same release when it is back in operation.</Action>";
	    echo "<Advice>The update can be done on this cluster. Ensure the DR site is also updated to same release when it is back in operation.</Advice>";
	    echo "<RC>warning</RC>";
        }
        //elseif ($drcstate != 'normal') {
        elseif ($localmode != 'normal') {
            echo "<Alert>Automated NDU is not supported when MetroCluster is in the operational mode \"$localmode\".</Alert>";
	    echo "<Action>Verify that MetroCluster is configured and in the operational mode \"normal\" before attempting NDU.</Action>";
	    echo "<Advice>Verify that MetroCluster is configured and in the operational mode \"normal\" before attempting NDU.</Advice>";
	    echo "<RC>error</RC>";
        }
        else {
	    echo "<Alert>MetroCluster is configured on this cluster.</Alert>";
	    echo "<Action>The updates can be done one cluster at a time or both clusters at the same time.</Action>";
	    echo "<Advice>The updates can be done one cluster at a time or both clusters at the same time.</Advice>";
	    echo "<RC>warning</RC>";
        }
    }
    elseif ($mccstate != 'not-configured') {
        echo "<Alert>Automated NDU is not supported when MetroCluster is in the configuration state \"$mccstate\".</Alert>";
	echo "<Action>Verify that MetroCluster is configured and in the operational mode \"normal\" before attempting NDU.</Action>";
	echo "<Advice>Verify that MetroCluster is configured and in the operational mode \"normal\" before attempting NDU.</Advice>";
        echo "<RC>error</RC>";
    }
exit;
?>
