<?php
//
//  Copyright (c) 2014 NetApp, Inc.
//  All rights reserved.
//
// VERSION="1.0"
// NDU Compatibility for SCON

include 'mcc_util.php';
include 'vserver_state_cache.php';

// this is the max number of incorrectly configured lifs we will report.
// If there are additional misconfigured LIFs, then we will not list details
// of them, just note there are additional ones not listed
$MAX_LIFS_TO_REPORT = 3;
$FS_BATCH_UPGRADE_NODE_THRESHOLD = 8;

$options = getoptreq( '', array("major:", "downgrade::", "isrolling::"));
$severity = "warning";

// we do not want to run this check if we are running 8.3.x
$ecvQuery = "SELECT generation,major FROM effective_cluster_version";
$result = dotsql_query($ecvQuery);
$row = dotsql_fetch_object($result);
if( $row ){
    $gen = $row->{'generation'};
    $major = $row->{'major'};
    if( ($gen > 8) || ($gen == 8 && $major >= 4)){
	$severity = "error";
	if( $options["isrolling"] == "true" ){
	    $doCheck = false;
	}
	else{
	    $doCheck = true;
	}
    }
    else {
	// in a fs cluster we can't error out because we don't
	// know if this is a rolling or batch upgrade. so warn
	// if there are 8 or more nodes in the cluster which is
	// where batch upgrade is allowed
	$nodeQuery = "SELECT node from node";
	$nodeResult = dotsql_query($nodeQuery);
	if( $nodeResult ){
	    $nodecount = dotsql_num_rows($nodeResult);
	    if( $nodecount >= $FS_BATCH_UPGRADE_NODE_THRESHOLD ){
		$doCheck = true;
	    }
	}
    }
}


if( $doCheck == "true" ){
    // search for LIFs that have load balancing turned on and warn the 
    // admin
    $query = "SELECT vserver, lif FROM virtual_interface where status-admin=up and allow-lb-migrate=true";
    $result = dotsql_query($query);
    $first = 1;
    $lifCount=0;
    unset( $row );
    unset( $lifs );

    while ($row = dotsql_fetch_object($result)) {

	unset( $vserverName );
	unset( $vserverState );
	unset( $vserverType );

	// get the state of the vserver, in this case we don't care about type
	// since only data vservers can have lb lifs
	$vserverName =$row->{'vserver'}; 
	list($vserverState, $vserverType) = getVserverInfo($vserverName);

	// only data vservers can have load balanced lifs so a simple
	// check for running is fine
	if( $vserverState == "running" ){

	    $lif = $row->{'lif'};
	    $lifCount++;

	    if( $lifCount <= $MAX_LIFS_TO_REPORT ){
		// build a list of the LIFs with load balancing enabled
		if( $first == 0 ){
		    $lifs .= ",";
		}
		else{
		    $first = 0;
		}
		$lifs .= "\"$lif\" on Vserver \"$vserverName\"";
	    }
	}
    }

    if( $lifs ){
	unset( $msg );
	if( $lifCount == 1 ){
	    $msg = "LIF %s has ";
	}
	else{
	    $additionalLifMsg = "";
	    if( $lifCount > $MAX_LIFS_TO_REPORT ){
		$unlabeledLifCount = $lifCount - $MAX_LIFS_TO_REPORT;
		$additionalLifMsg .= " and $unlabeledLifCount other LIFs";
	    }

	    $msg = "LIFs %s" . $additionalLifMsg ." have ";
	}

	$msg .= "load balancing enabled.";
	$msg = sprintf( $msg, $lifs );

	echo "<Alert>$msg</Alert>";
	echo "<Action>LIFs with load balancing enabled may migrate to a rebooting node during the upgrade process. To identify LIFs with load balancing enabled,";
	echo " use the \"network interface show -allow-lb-migrate true\" command. ";
	echo "To disable load balancing, use the \"network interface modify -vserver <Vserver> -lif <lif name> -allow-lb-migrate false\" command.</Action>";
	echo "<Advice>Turn off load balancing by setting the LIF's \"allow-lb-migrate\" parameter to \"false\".</Advice>";
	echo "<RC>$severity</RC>";
    }
}
exit;
?>

