<?php
//
// Copyright (c) 2016 NetApp, Inc.
// All rights reserved.
//
// VERSION="1.0"

// Check for  AUTOBOOT value on all nodes
include 'mcc_util.php';
$options = getoptreq('',array("major:", "downgrade::"));
$major = $options["major"];
if ($major != "true") {
	exit;
}
$nodelist = array();
$query = "SELECT node FROM debug_kenv where variable = 'AUTOBOOT' and value != 'true'";
$result = dotsql_query($query);
while ($row = dotsql_fetch_object($result)) {
	$node = $row->{'node'};
	array_push($nodelist, "$node");
}
if(count($nodelist) > 0) {
	echo "<Alert>AUTOBOOT is disabled on nodes: ".implode(",",$nodelist)."</Alert>";
	echo "<Action>Set the AUTOBOOT bootarg to true and retry the operation.</Action>";
	echo "<Advice>Enable the AUTOBOOT and retry the operation.</Advice>";
	echo "<RC>error</RC>";
}
exit;
?>

