<?php
//
//  Copyright (c) 2014 NetApp, Inc.
//  All rights reserved.
//

// VERSION="1.0"

//
// Check if aggregates are offline
//
include 'mcc_util.php';
global $mccconfigured;
global $mccswitchedover;
$offlineaggrfound = false;

$options = getoptreq('',array("major:", "downgrade::"));
$majorupgrade = $options["major"];

if(!isValidMCCState()) {
    exit;
}

$queryaggr = "SELECT cluster-id FROM aggr WHERE state != online";
$resultaggr = dotsql_query($queryaggr);

if ($mccconfigured) {
    while ($rowaggr = dotsql_fetch_object($resultaggr)) {
        $clusterid = $rowaggr->{'cluster-id'};
        $querycid = "SELECT uuid from cluster_id";
        $resultcid = dotsql_query($querycid);
        if($rowcid = dotsql_fetch_object($resultcid)) {
            if($rowcid->uuid != $clusterid) {
                if(!$mccswitchedover){
                    // No aggrs are shown offline when mcc is in normal state. So should not enter here
                    continue;
                }
                else {
                    // DR site root aggregates will be shown as offline during switched-over, heal-aggregates, heal-root-aggregates phases. Skip them.
                    // Only reliable attribute to check if it is DR site root aggr is ha-policy. The value could be null after heal-root-aggregates.
                    $hapolicy= $rowaggr->{'ha-policy'};
                    if($hapolicy == 'cfo' || $hapolicy == '') {
                        continue;
                    }
                    else {
                        $offlineaggrfound = true;
                        break;
                    }
                }
            }
            else {
                //Found a local site offline aggregate
                $offlineaggrfound = true;
                break;
            }
        }
    }
} elseif (dotsql_num_rows($resultaggr)) {
    //echo "Not an MCC configuration and there are some offline aggregates...";
    $offlineaggrfound = true;
}



if ($offlineaggrfound) {
    echo "<Alert>Not all aggregates are in online state, make sure all aggregates are online before attempting NDU.</Alert>";
    echo "<Action>To check for offline aggregates run the command: storage aggregate show -state !online</Action>";
    echo "<Advice>Check for offline aggregates in the cluster.</Advice>";
    if($majorupgrade == "true") {
        echo "<RC>error</RC>";
    }
    else {
        echo "<RC>warning</RC>";
    }
}

exit;
?>
