<?php
//
//  Copyright (c) 2015 NetApp, Inc.
//  All rights reserved.
//

// VERSION="1.0"

//Check if they are active volume moves while performing a pre-check for
// update of image.

function logDebugMessage($message) {
    $dbgquery = "CALL add_scripting_log_message('validation_rules_volume_move_check: $message','false')";
    $result = dotsql_query($dbgquery);
}

$printed = false;

$querymoves = "SELECT operational-id FROM volumeMoveStoredTable WHERE state != done AND state != failed";
$resultmoves = dotsql_query($querymoves);

if (dotsql_num_rows($resultmoves) > 0) {
    echo "<Alert>";
    echo "There are active volume moves in the cluster. Use the 'volume move show'
         command to display them.";
    echo "</Alert> <Action>";
    echo "Ensure there are no active volume moves before attempting NDU.";
    echo "</Action>";
    echo "<Advice>Check for active volume moves in the cluster.</Advice>";
    echo "<RC>error</RC>";
} else {
    logDebugMessage("No active volume moves were found.");
}

exit;
?>
