<?php
//
// Copyright (c) 2012-2014 NetApp, Inc.
// All rights reserved.
//

// VERSION="1.0"

//
// Check that takeover is possible
//
$found = "false";
$cluster_ha_printed = "false";
$takeover_printed = "false";

$query = "SELECT node, possible FROM storage_failover";
$cluster_query = "SELECT node, epsilon, eligibility, health FROM cluster";
$ha_query = "SELECT configured,sfo-configured FROM cluster_ha";

$result = dotsql_query($cluster_query);
if (dotsql_num_rows($result) == 2) {
    $result = dotsql_query($ha_query);
    if ($row = dotsql_fetch_object($result)) {
       if (($row->configured != "true") || ($row->{'sfo-configured'} != "true")) {
         echo "<Alert>Cluster HA is not configured in the cluster";
         $cluster_ha_printed = "true";
     }
   }
}

$result = dotsql_query($query);
while ($row = dotsql_fetch_object($result)) {
   if ($row->possible != "true") {
      if ($takeover_printed != "true") {
         if ($cluster_ha_printed != "true") {
          echo "<Alert>";
	 } else {
          echo ". ";
	 }
	 echo "Storage failover is not enabled on node \"$row->node\"";
         $takeover_printed = "true";
      } else {
         echo ", \"$row->node\"";
      }
   }
}

if (($takeover_printed == "true") || ($cluster_ha_printed == "true")) {
   echo ".";
   echo "</Alert> <Action>";
}

if ($cluster_ha_printed == "true") {
   echo "Ensure that cluster HA is configured before attempting NDU. ";
   echo "To check for cluster HA configuration, run \"cluster ha show\". ";
}

if ($takeover_printed == "true") {
   echo "Ensure storage failover is enabled on all nodes before attempting NDU. ";
   echo "To check for storage failover status, run \"storage failover show\". ";
}

if (($takeover_printed == "true") || ($cluster_ha_printed == "true")) {
   echo "</Action> <RC>error</RC>";
   echo "<Advice>";
}

if ($takeover_ha_printed == "true") {
    echo "Check cluster HA configuration. ";
}

if ($cluster_ha_printed == "true") {
    echo "Check storage failover status.";
}

if (($takeover_printed == "true") || ($cluster_ha_printed == "true")) {
   echo "</Advice>";
}

exit;
?>
