<?php
//
//  Copyright (c) 2014 NetApp, Inc.
//  All rights reserved.
//
// VERSION="1.0"
// NDU Compatibility for SCON
$MAX_LIFS_TO_REPORT = 3;

class incorrigibleLifInfo{
    var $lifName;
    var $vserverId;
};

class vserverInfo{
    var $name;
    var $state;
};

// search for incorrigible LIFs as they should be fixed before the upgrade is allowed to take place
$incorrigible_query = "SELECT vsrv_id_col, vif_name_col, vif_state_col FROM vif_table WHERE vif_state_col=incorrigible";
$result = dotsql_query($incorrigible_query);
$first = 1;
$iLifCount=0;
unset( $iLifs );

//track all incorrigible lifs in an array
while ($row = dotsql_fetch_object($result)) {
    $iLif=new incorrigibleLifInfo;
    $iLif->lifName = $row->{'vif_name_col'};
    $iLif->vserverId = $row->{'vsrv_id_col'};
    $iLifs[]=$iLif;
}

unset( $iLif );
unset( $result );
unset( $incorrigibleLifs );

// get the vserver namefor each incorrigible lif the number of incorrigible lifs
// is assumed to be small compared to the total number of lifs so its probably ok
// to do sql queries for each of them.  To alleviate the load, we cache the results
if( $iLifs ){
    foreach( $iLifs as $iLif ){
	unset( $vserverName );
	unset( $vserverState );

	// check cache for vserver name
	if($vserverCache[$iLif->vserverId]){
	    $vserverName=$vserverCache[$iLif->vserverId]->name;
	    $vserverState=$vserverCache[$iLif->vserverId]->state;
	}
	else{
	    // map the vserver id to the vserver name 
	    $vsrvNameQuery = "SELECT vserver FROM vserver_by_name WHERE id=" . $iLif->vserverId;
	    $result = dotsql_query($vsrvNameQuery);
	    if( $result && (dotsql_num_rows( $result ) == 1) ) {
		$row = dotsql_fetch_object($result);
		if( $row ){
		    $vserverName=$row->{'vserver'};

		    // get the vserver state from a different table where it is available
		    $vsrvNameQuery = "SELECT admin-state FROM vserver WHERE vserver=" . $vserverName;
		    $result = dotsql_query($vsrvNameQuery);
		    if( $result && (dotsql_num_rows( $result ) == 1) ) {
			$row = dotsql_fetch_object($result);
			if( $row ){
			    // get the vserver name,state and add it to the cache
			    $vserverState=$row->{'admin-state'};

			    $cacheEntry = new vserverInfo;
			    $cacheEntry->name=$vserverName;
			    $cacheEntry->state=$vserverState;

			    $vserverCache[$iLif->vserverId]=$cacheEntry;
			}
		    }
		}
	    }
	}

	// system vservers do not have an admin state, because system vservers
	// are always running we treat having no value as running
	if( !$vserverState || $vserverState == "running" ){
	    $name = $iLif->lifName;
	    $incorrigibleLifCount++;
	    if( $incorrigibleLifCount <= $MAX_LIFS_TO_REPORT ){
		if( $first == 0 ){
		    $incorrigibleLifs .= ",";
		}
		else{
		    $first = 0;
		}
		$incorrigibleLifs .= "\"$name\" for Vserver \"$vserverName\""; 
	    }
	}
    }
}

if( $incorrigibleLifs ){
    unset( $msg );

    if( $incorrigibleLifCount == 1 ){
	$msg = "LIF %s is not hosted on a network port.";
    }
    else{
	$additionalLifMsg = "";
	$additionalLifCount = $incorrigibleLifCount - $MAX_LIFS_TO_REPORT;
	if( $additionalLifCount > 0 ){
	    $additionalLifMsg = "and $additionalLifCount other LIFs";
	}
	$msg = "LIFs %s $additionalLifMsg are not hosted on a network port.";
    }
    $msg = sprintf( $msg, $incorrigibleLifs );

    echo "<Alert>$msg</Alert>";
    echo "<Action>To identify LIFs that are no longer hosted use the \"network interface show -status-admin up -status-oper down\" command.</Action>";
    echo "<Advice>Check the failover-group and failover-policy for each LIF to make sure there is a network port it can fail over to ";
    echo "or migrate the LIF to a port that is operational.</Advice>";
    echo "<RC>warning</RC>";
}

exit;
?>
