#!/bin/csh
#
# Copyright (c) 2016 NetApp, Inc.
# All rights reserved.
#
# Check for CPU utilization of all nodes in the cluster

# Get the list of nodes in the cluster.
sudo /sbin/ngsh -c "cluster show -fields node" | sed -e 1,2d -e 'N;$\!P;$\!D;$d' > cluster.txt

set index = 1
set error = 0

foreach line ("`cat cluster.txt`")
    set node = "`echo $line | tr -d '[[:space:]]'`"	# Remove newline character
    set command = `echo "set -privilege test -confirmations off; system node run -node $node -command sysstat -c 10 3"`
    sudo /sbin/ngsh -c $command | strings > output$index &
    @ index++
end

rm cluster.txt

wait					# Wait till the background commands complete

set valid_cpu_util = 0			# Valid numerical CPU utilization value
set cpu_util = 0

# Iterates through the output of cluster show
set i = 1
while( $i < $index)
    foreach row("`cat output$i`")
        set cpu_util = `echo ${row} | sed 's/%.*//' | sed "s/[^0-9]//g"`
        # this is to ensure that only intergers are considered
        if ( $cpu_util != "") then
            set valid_cpu_util = "$cpu_util"
        endif

        if ( $valid_cpu_util >= 50 ) then
            set error = 1
            break
        endif
    end

    rm output$i
    @ i++
end

if ( "$error" == 1) then
    echo "<Alert>CPU Utilization is high on few nodes.</Alert><Action>Before updating any nodes, verify that no node in the cluster is above 50% CPU utilization.  Use the command : node run -node <nodenames> -command sysstat -c 10 3 to view the CPU utilization of nodes.</Action><Advice>Ensure the CPU utilization on nodes is not more than 50%.</Advice><RC>warning</RC>" > /dev/stderr
endif

exit 0
